
// ChildView.cpp : CChildView NX̎
//

#include "stdafx.h"
#include "TestLib.h"
#include "ChildView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace RLib;

void RichEditCtrl_AddString(CRichEditCtrl &richEditCtrl,const CString &sString)
{

	if( richEditCtrl.GetSafeHwnd() ){
		SCROLLINFO si = {0,};
		si.cbSize = sizeof(si);
		richEditCtrl.GetScrollInfo(SB_VERT,&si);						// cXN[o[݈̌ʒu擾
		const int nLineCount = richEditCtrl.GetLineCount();				// s
		long start,end;
		richEditCtrl.GetSel(start,end);									// IĂ镔
		const long nLineFromChar = richEditCtrl.LineFromChar(start);
		const bool bIsLastLine = nLineFromChar >= ( nLineCount - 1 );	// ŏIsH
		const bool bIsSelected = start != end;							// IĂ邩H
		richEditCtrl.SetSel( -1,-1 );									// ŏIʒuŃeLXgI(J[\ړ)
		richEditCtrl.ReplaceSel(sString);								// eLXg}

		if( bIsSelected || !bIsLastLine ){								// XN[ʒuǏ]ȂȂ
			richEditCtrl.SetSel(start,end);												// Iɖ߂
			richEditCtrl.PostMessage(WM_VSCROLL, MAKELONG(SB_THUMBPOSITION,si.nPos));	// XN[ʒuɖ߂
		}else{																			// XN[ʒuǏ]ꍇ
			richEditCtrl.PostMessage(WM_VSCROLL, MAKELONG(SB_BOTTOM, NULL));			// ŏIs\悤ɃXN[
		}

	}
}



// CChildView

CChildView::CChildView()
{
}

CChildView::~CChildView()
{
}

void CChildView::OnMessage(const CString &sMessage)
{
	CString s = CRString::Format( _T("\xd\xa%s %s"),COleDateTime::GetCurrentTime().Format(),sMessage);
	ATLTRACE(s);

	RichEditCtrl_AddString(m_richEditCtrl,s);

}

BEGIN_MESSAGE_MAP(CChildView, CWnd)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_SIZE()
END_MESSAGE_MAP()



// CChildView bZ[W nh

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), reinterpret_cast<HBRUSH>(COLOR_WINDOW+1), NULL);

	return TRUE;
}

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // `̃foCX ReLXg
	
	// TODO: ɃbZ[W nh R[hǉ܂B
	
	// bZ[W̕`̂߂ CWnd::OnPaint() ĂяoȂłB
}


int CChildView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	::AfxInitRichEdit2();
	m_richEditCtrl.Create(ES_LEFT|ES_AUTOHSCROLL|ES_AUTOVSCROLL|ES_MULTILINE|ES_READONLY|WS_VISIBLE|WS_CHILD|WS_HSCROLL|WS_VSCROLL|WS_BORDER,CRect(0,0,0,0),this,0);
	{
		// fAtHg[h𖳌ɂ
		DWORD dwLangOptions = SendMessage(EM_GETLANGOPTIONS, 0, 0); 
		dwLangOptions &= ~IMF_DUALFONT;
		m_richEditCtrl.SendMessage(EM_SETLANGOPTIONS, 0, (LPARAM)dwLangOptions);
		// tHgݒ
		CHARFORMAT2 cf;
		m_richEditCtrl.GetDefaultCharFormat(cf);
		cf.dwMask = CFM_SIZE | CFM_FACE;
		lstrcpy(cf.szFaceName, _T("lr SVbN"));
		cf.yHeight = 150;
		m_richEditCtrl.SetDefaultCharFormat(cf);
	}

	return 0;
}

void CChildView::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	CRect ClientRect;
	GetClientRect( &ClientRect );
	CSize sizeClient(ClientRect.Size());
	m_richEditCtrl.SetWindowPos (NULL, 0, 0, sizeClient.cx, sizeClient.cy, SWP_NOMOVE | SWP_NOACTIVATE | SWP_NOZORDER);
}
